#pragma once
#include "common_action.h"

class TDeleteAction: public TCommonAction {
public:
    static TFactory::TRegistrator<TDeleteAction> Registrator;
    virtual void DoPrepare() {
        ModifyResult = IndexersThread->ProcessDelete(Document, "QUEUE_SHARD_" + ToString(Shard));
        ModifyResult.UpdateStatus(TModifyResult::COMPLETED);
        Document->SetStatus(NRTYServer::TReply::OK, "del_count=" + ToString(ModifyResult.Count) + ";");
    }
};
