#include "disk_indexer_updater.h"
#include "indexer.h"

#include <saas/rtyserver/config/common_indexers_config.h>
#include <saas/rtyserver/config/indexer_config.h>

TDiskIndexUpdater::TDiskIndexUpdater(TIndexer& owner)
    : TDeferredIndexUpdater(owner, new TDeferredUpdatesStorage(owner.Config.Common.Owner))
    , DiskIndex(owner)
    , Storage(GetDeferredUpdatesStorage())
{}

bool TDiskIndexUpdater::UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc) {
    if (docId != REMAP_NOWHERE) {
        TIndexer::TDocIdToSearchInfo::const_iterator i = DiskIndex.DocId2SearchInfo.find(docId);
        if (i == DiskIndex.DocId2SearchInfo.end()) {
            ERROR_LOG << "Did not find docid " << docId << ", TDiskIndexUpdater failed." << Endl;
            return false;
        }
    }
    return TIndexUpdater::UpdateDoc(docId, doc) | TDeferredIndexUpdater::UpdateDoc(docId, doc);
}

bool TDiskIndexUpdater::UpdateDocNative(ui32 /*docId*/, const TParsedDocument::TPtr /*doc*/) {
    return false;
}
