#pragma once

#include <saas/library/daemon_base/metrics/metrics.h>
#include <saas/library/daemon_base/metrics/persistent.h>

struct TIndexerMetrics : public TCompositeMetric {
    TPart<TOrangeMetric> DocumentAdd;
    TPart<TOrangeMetric> DocumentDelete;
    TPart<TOrangeMetric> DocumentDuplicated;
    TPart<TOrangeMetric> DocumentFail;
    TPart<TOrangeMetric> DocumentModify;
    TPart<TOrangeMetric> DocumentOutdated;
    TPart<TOrangeMetric> DocumentUpdate;
    TPart<TOrangeMetric> DocumentRedundant;

    TIndexerMetrics()
        : DocumentAdd(this, GetMetricsPrefix() + "Indexer_DocumentsAdded")
        , DocumentDelete(this, GetMetricsPrefix() + "Indexer_DocumentsDeleted")
        , DocumentDuplicated(this, GetMetricsPrefix() + "Indexer_DocumentsDuplicated")
        , DocumentFail(this, GetMetricsPrefix() + "Indexer_DocumentsFailed")
        , DocumentModify(this, GetMetricsPrefix() + "Indexer_DocumentsModified")
        , DocumentOutdated(this, GetMetricsPrefix() + "Indexer_DocumentsOutdated")
        , DocumentUpdate(this, GetMetricsPrefix() + "Indexer_DocumentsUpdated")
        , DocumentRedundant(this, GetMetricsPrefix() + "Indexer_DocumentsRedundant")
    {
    }
};
