#pragma once

#include <saas/rtyserver/modifier/index_updater.h>

class TMemoryIndexer;

class TMemoryIndexerUpdater : public TIndexUpdater {
public:
    TMemoryIndexerUpdater(TMemoryIndexer& owner);

protected:
    virtual bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc);
    virtual bool RestoreDoc(ui32 /*docId*/, TParsedDocument::TPtr& /*doc*/) {
        return false;
    }

private:
    bool UpdateGroupAttributes(ui32 docid, const TParsedDocument& doc);
    bool UpdateFillers(ui32 docid, const TParsedDocument& doc);

private:
    TMemoryIndexer& MemoryIndexer;
};
