#pragma once

#include "search_manager.h"

namespace NMemorySearch {
    class IDataConsumer;
    class TMemorySearch;
}

class TMemorySearchManager: public IRealtimeSearchManager {
private:
    const NRTYServer::TSearcherConfig& SearcherConfig;
    const ui32 Shard;

    THolder<NMemorySearch::TMemorySearch> MemorySearch;
    NMemorySearch::IDataConsumer* MemoryYndexWriter;
protected:
    class TReadContext;

public:
    TMemorySearchManager(IIndexController::TPtr contoller, const NRTYServer::TSearcherConfig& searcherConfig);
    virtual ~TMemorySearchManager();

    virtual const IArchiveData* GetArchiveData() const override;
    virtual TBaseCommonSearch* GetCommonSearch() override;
    virtual const NGroupingAttrs::TDocsAttrs* GetDocsAttrs() const override;
    virtual const IReadContext::TPtr GetKeysAndPositions() const override;

    virtual void BanDoc(const ui32 docId) override;
    virtual bool HasDoc(const TString& url, ui32& docId) const override;

    virtual void SignalSearchingStart() override;
    virtual void SearchOpen(TAutoPtr<TSearchConfig> config, const NRTYServer::TIndexerConfig& /*indexerConfig*/, TRTYIndexData* indexData) override;
    virtual void SearchClose() override;

    virtual ERequestType RequestType(const TCgiParameters& cgi) const override;
    virtual NMemorySearch::EConsumeDataResult Consume(NRealTime::TIndexedDoc* indexedDoc, const TDocSearchInfo& docInfo, TCondVar& cvWaitMutex, TMutex& mutexIndex, TQueriesMetrics& consumeMetrics) override;
    virtual ui32 GetDocLen(ui32 docid) const override;
};
