#pragma once

#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/common/common_rty.h>
#include <search/memory/indexeddoc/info.h>

#include <kernel/search_daemon_iface/reqtypes.h>

#include <util/generic/ptr.h>

class IArchiveData;

class TBaseCommonSearch;
class TCgiParameters;
class TCondVar;
class TMutex;
class TRTYIndexData;
class TQueriesMetrics;

namespace NGroupingAttrs {
    class TDocsAttrs;
}

class IRealtimeSearchManager: public IDocLenCalcer {
public:
    class IReadContext {
    public:
        using TPtr = TAtomicSharedPtr<IReadContext>;

    public:
        virtual ~IReadContext() {}
        virtual const IKeysAndPositions* Get() const = 0;
    };

public:
    virtual ~IRealtimeSearchManager() {
    }

    virtual ERequestType RequestType(const TCgiParameters& cgi) const = 0;
    virtual NMemorySearch::EConsumeDataResult Consume(NRealTime::TIndexedDoc* indexedDoc, const TDocSearchInfo& docInfo, TCondVar& cvWaitMutex, TMutex& mutexIndex, TQueriesMetrics& consumeMetrics) = 0;
    virtual TBaseCommonSearch* GetCommonSearch() = 0;
    virtual const IArchiveData* GetArchiveData() const = 0;
    virtual void SearchOpen(TAutoPtr<TSearchConfig> config, const NRTYServer::TIndexerConfig& indexerConfig, TRTYIndexData* indexData) = 0;
    virtual void SearchClose() = 0;
    virtual void SignalSearchingStart() = 0;
    virtual bool HasDoc(const TString& url, ui32& docId) const = 0;
    virtual void BanDoc(const ui32 docId) = 0;
    virtual const IReadContext::TPtr GetKeysAndPositions() const = 0;
    virtual const NGroupingAttrs::TDocsAttrs* GetDocsAttrs() const = 0;
    virtual ui32 GetDocLen(ui32 docid) const override;
};
