#pragma once

#include "indexers_list.h"
#include "documents_queue.h"

#include <saas/rtyserver/modifier/document_modifier.h>

#include <util/thread/pool.h>

struct TIndexerMetrics;

struct TIndexersThread : public IObjectInQueue {
    TAtomicSharedPtr<TIndexersList> IndexersList;
    TSynchronizedDocumentsQueue* DocumentsQueue;
    TIndexerMetrics* IndexerMetrics;
    const TRTYServerConfig& Config;
    const TString& ServiceName;
    TDocumentModifier& Deleter;

public:
    TIndexersThread(TAtomicSharedPtr<TIndexersList> indexersList, TSynchronizedDocumentsQueue& queue, TDocumentModifier& deleter,
        const TRTYServerConfig& config, const TString& serviceName, int threadID
    )
        : IndexersList(indexersList)
        , DocumentsQueue(&queue)
        , IndexerMetrics(nullptr)
        , Config(config)
        , ServiceName(serviceName)
        , Deleter(deleter)
        , ThreadID(threadID)
    {}

    TIndexersPack::TPtr GetIndexer(int shard) {
        return IndexersList->Get(shard);
    }
public:
    inline ui32 GetThreadID() {
        return ThreadID;
    }
    inline bool IsActive() {
        return IndexersList->IsActive();
    }
    inline bool IsRigidStop() {
        return IndexersList->IsRigidStop();
    }
    inline TIndexerMetrics* GetIndexerMetrics() const {
        return IndexerMetrics;
    }
    inline const TString& GetServiceName() const noexcept {
        return ServiceName;
    }

    TModifyResult ProcessDelete(TQueuedDocument& document, const TString& indexName);
    TModifyResult ProcessUpdate(TQueuedDocument& document, const TString& indexName, bool mayFast);

protected:
    TModifyResult ModifyDocument(const TQueuedDocument& document, IModifyAction* action);
    bool IsRealtime(TQueuedDocument& document) const;

private:
    ui32 ThreadID;
};
