#pragma once

#include <library/cpp/logger/global/rty_formater.h>
#include <util/stream/str.h>
#include <array>

namespace NEscaper {
    class TEscaper {
    public:
        TEscaper();

        explicit TEscaper(TStringBuf str);

        void AddMapping(char key, TStringBuf value);

        void SetStr(TStringBuf str);

        friend IOutputStream &operator<<(IOutputStream &out, const TEscaper &escaper);

    private:
        TStringBuf str_;
        std::array<ui8, 256> used_keys_;
        std::array<TStringBuf, 256> values_;
    };
}
