#include "escaping.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/stream/str.h>

namespace NRtyAccess {
    NEscaper::TEscaper LoadlogQueryEscaper(TStringBuf str);
}

Y_UNIT_TEST_SUITE(TestLoadlogEscaping) {
    Y_UNIT_TEST(EmptyTest) {
        const TString query = "";
        const TString expected = "";
        TStringStream result;
        result << NRtyAccess::LoadlogQueryEscaper(query);
        UNIT_ASSERT(result.Str() == expected);
    }
    Y_UNIT_TEST(SimpleTest) {
        const TString query = "Hello, world";
        const TString expected = "Hello, world";
        TStringStream result;
        result << NRtyAccess::LoadlogQueryEscaper(query);
        UNIT_ASSERT(result.Str() == expected);
    }
    Y_UNIT_TEST(SemicolonsTest) {
        const TString query = "Hello;; world";
        const TString expected = "Hello%3B%3B world";
        TStringStream result;
        result << NRtyAccess::LoadlogQueryEscaper(query);
        UNIT_ASSERT(result.Str() == expected);
    }
    Y_UNIT_TEST(SemicolonAndTabTest) {
        const TString query = "\tHello; world";
        const TString expected = "%09Hello%3B world";
        TStringStream result;
        result << NRtyAccess::LoadlogQueryEscaper(query);
        UNIT_ASSERT(result.Str() == expected);
    }
}
