#pragma once

#include <library/cpp/logger/global/rty_formater.h>

#include <kernel/searchlog/searchlog.h>
#include <kernel/search_daemon_iface/reqtypes.h>

#include <util/datetime/base.h>

class TRTYAccessLog: public TSearchLog {
public:
    TRTYAccessLog(const TString& logType, ELogPriority priority = LOG_MAX_PRIORITY, size_t queueLen = 0)
        : TSearchLog(logType, priority, queueLen)
    {

    }
    static void LogIncoming(ui64 id, ui32 count, const TStringBuf address, const TStringBuf query);
    static void LogSearch(ui64 id, TDuration full, TDuration process, bool result, ui32 totalCount, ui32 reportCount, ui64 byteSize, float cacheHit, ui32 unanswerCnt, ERequestType requestType, ui32 fastCacheHit = 0, bool failOnZero = false, i32 answerIsComplete=-1, TStringBuf searchErrors="");
    static void LogFetch(ui64 id, TDuration full, TDuration process, bool result);
    static void LogError(ui64 id, TDuration full, const TStringBuf error);
    static void LogError(const TStringBuf error);
};

template<>
class TSingletonTraits < TLoggerOperator<TRTYAccessLog>::TPtr > {
public:
    static const size_t Priority = NLoggingImpl::SingletonPriority;
};
