#pragma once

#include <saas/rtyserver/indexer_core/merger_interfaces.h>

#include <util/generic/map.h>
#include <util/generic/vector.h>
#include <util/system/compiler.h>
#include <util/system/mutex.h>

namespace NRTYMerger {
    class TAggregator: public IIndexController::ICallback {
    public:
        struct TData {
            TVector<ui32> RemovedDocIds;
            TMap<ui32, TVector<ui32>> MarkedDocIds;
        };

    public:
        TAggregator(TIndexControllerPtr controller);
        ~TAggregator();

        // public interface is sequentially consistent wrt OnBefore* callbacks
        [[nodiscard]] TAggregator::TData Detach(); // produce aggregation results and proceed from clear state
        void Deactivate(); // deactivate callbacks

    protected: // IIndexController::ICallback
        void OnBeforeRemove(const TVector<ui32>& docIds);
        void OnBeforeMark(const TVector<ui32>& docIds, ui32 marker);

    private:
        TIndexControllerPtr Controller;
        TMutex RemoveMutex;
        TMutex MarkMutex;
        TData Data;
    };

}
