#include "doc_extractor.h"

#include <saas/rtyserver/config/const.h>
#include <saas/rtyserver/model/index.h>

#include <library/cpp/logger/global/global.h>

TDocumentsExtractor::TDocumentsExtractor(const NSaas::TShardsDispatcher::TContext& context)
    : ShardsDispatcher(context)
{
}

void TDocumentsExtractor::GetDocPlaceMap(const IIndexController& controller, TDocPlaceMap& result) const {
    THolder<NRTYServer::IDocSearchInfoIterator> iterator = controller.GetManager(FULL_ARCHIVE_COMPONENT_NAME)->GetDocSearchInfoIterator();
    THolder<TPruningConfig::ICalcer> pruningCalcer = controller.CreatePruningCalcer();
    CHECK_WITH_LOG(iterator);
    CHECK_WITH_LOG(pruningCalcer);

    result.resize(controller.GetDocumentsCount(true));
    for (; iterator->IsValid(); iterator->Next()) {
        const TDocSearchInfo& info = iterator->Get();
        CHECK_WITH_LOG(info.GetDocId() < result.size());

        TDocPlaceInfo& doc = result[info.GetDocId()];
        doc.PruningRank = pruningCalcer->PruningRank(info.GetDocId());
        doc.Shard = ShardsDispatcher.GetShard(info.GetUrl(), info.GetKeyPrefix());
    }
}
