#pragma once

#include <saas/library/sharding/sharding.h>

class IIndexController;

struct TDocPlaceInfo {
    TDocPlaceInfo()
        : Shard(0)
        , PruningRank(0)
    {}

    TDocPlaceInfo(NSearchMapParser::TShardIndex shard, double pruningRank)
        : Shard(shard)
        , PruningRank(pruningRank)
    {}

    NSearchMapParser::TShardIndex Shard;
    double PruningRank;
};

typedef TVector<TDocPlaceInfo> TDocPlaceMap;

class TDocumentsExtractor {
public:
    using TContext = NSaas::TShardsDispatcher::TContext;

public:
    TDocumentsExtractor(const NSaas::TShardsDispatcher::TContext& context);

    void GetDocPlaceMap(const IIndexController& controller, TDocPlaceMap& result) const;
private:
    NSaas::TShardsDispatcher ShardsDispatcher;
};
