#include "docurl_op.h"

#include <kernel/doc_url_index/doc_url_index.h>

#include <library/cpp/on_disk/2d_array/array2d_writer.h>


namespace {
    TString Name = "DocUrl";
}

TString TDocUrlMerger::GetName() const {
    return Name;
}

bool TDocUrlMerger::Merge(const std::atomic<bool>* stopKey, TMergeDocInfos& /*infos*/, const TRTYMerger::TContext& context) {
    TVector<THolder<TDocUrlIndexReader>> inputs;
    inputs.reserve(context.Sources.size());

    const TString indexName(TString::Join(::INDEX_SUFFIX, context.AdditionalSuffixIndexName, ".docurl"));
    for (ui32 i = 0; i < context.Sources.size(); ++i) {
        TFsPath fs(TString::Join(context.Sources[i], '/', indexName));
        inputs.emplace_back(new TDocUrlIndexReader(fs.Fix()));
    }

    for (ui32 i = 0; i < context.Dests.size(); ++i) {
        const TString tmpOutputPath(TString::Join(context.Dests[i], indexName, ".tmp"));
        {
            TFile2DArrayWriter<ui32, char> writer(tmpOutputPath);

            TRTYMerger::TAddress addr;
            ui32 docsWrite = 0;
            for (ui32 idDoc = 0; context.Decoder->NewToOld(i, idDoc, addr); ++idDoc) {
                const TStringBuf url = inputs[addr.ClusterId]->Get(addr.DocId);
                if (idDoc) {
                    writer.NewLine();
                }
                for (const char c: url) {
                    writer.Write(c);
                }
                if (stopKey && *stopKey)
                    return false;
                ++docsWrite;
            }
            Y_VERIFY(context.Decoder->GetNewDocsCount(i) == docsWrite, "Inconsistent documents count");
            writer.Finish();
        }
        TFsPath(tmpOutputPath).RenameTo(TFsPath(TString::Join(context.Dests[i], indexName)));
    }
    return true;
}

