#pragma once
#include "merger.h"
#include "doc_infos.h"
#include <kernel/keyinv/indexfile/searchfile.h>
#include <ysite/yandex/erf/tf.h>

class TLengthBuilder: public TRTYMerger::IMergerOperator {
public:
    TString GetName() const override {
        return "Length";
    }

    bool Merge(const std::atomic<bool>* /*stopKey*/, TMergeDocInfos& /*infos*/, const TRTYMerger::TContext& context) override {
        for (size_t i = 0; i < context.Dests.size(); ++i) {
            TString destSuffixed(context.Dests[i] + ::INDEX_SUFFIX);
            TYndex4Searching yndex;
            yndex.InitSearch(destSuffixed);
            SaveYandLengths(yndex, destSuffixed.data(), false, true, true, true);
        }
        return true;
    }
};

