#pragma once
#include <saas/rtyserver/indexer_core/merger_interfaces.h>
#include <saas/rtyserver/merger/library/merger.h>
#include <saas/rtyserver/config/fwd.h>

#include <atomic>

class TMergerAction {
public:
    TMergerAction(const TRTYServerConfig& config, IMerger* merger, const TString& name);
    ~TMergerAction();
    bool Do(const TVector<TString>& sources, const TString& dest, TRTYMerger::IRTYMergerDocIdDecoder* decoder, TRTYMerger::IRTYMergerDocIdInfo* info, IMergerCallback* callback, const std::atomic<bool>* rigidStopSignal, IMergerTask* task);
    bool Do(const TVector<TString>& sources, const TVector<TString>& dests, const TVector<TString>& tmpfsDests, TRTYMerger::IRTYMergerDocIdDecoder* decoder, TRTYMerger::IRTYMergerDocIdInfo* info, IMergerCallback* callback, const std::atomic<bool>* rigidStopSignal, IMergerTask* task);

private:
    const TRTYServerConfig& Config;
    IMerger* const Merger;
    const TString Name;
    TFsPath TempDir;
};
