#include "merger_thread.h"
#include "merger_task.h"
#include "merger_action.h"

#include <library/cpp/balloc/optional/operators.h>

void TMergerAgent::Process(void* /*threadSpecificResource*/) {
    ThreadDisableBalloc();

    while (!DoStop) {
        IMergerTask::TPtr task = Merger.NextTask(10);
        if (!task)
            continue;
        INFO_LOG << "Starting merger task. Index segments number (" << task->GetSourceSegments().size() << ") exceeds limit " << Config.GetMergerConfig().MaxSegments << Endl;
        try {
            Merger.DoTask(task, &RigidStop);
        } catch (...) {
            ERROR_LOG << "Merge failed. CommandLine = " + task->GetName() << " : " << CurrentExceptionMessage() << Endl;
        }
    }
}

void TMergerAgent::Stop(bool rigidStop)
{
    DoStop = true;
    RigidStop = rigidStop;
}
