#pragma once

#include <saas/rtyserver/indexer_core/merger_interfaces.h>
#include <saas/rtyserver/config/fwd.h>
#include <util/thread/pool.h>

#include <atomic>

class TMergerAgent: public IObjectInQueue {
private:
    IMerger& Merger;
    const TRTYServerConfig& Config;
    std::atomic<bool> DoStop = false;
    std::atomic<bool> RigidStop = false;
public:

    typedef TAtomicSharedPtr<TMergerAgent> TPtr;

    TMergerAgent(const TRTYServerConfig& config, IMerger& merger)
        : Merger(merger)
        , Config(config)
    {
    }

    virtual ~TMergerAgent() {}
    void Stop(bool rigidStop);

private:
    virtual void Process(void* threadSpecificResource) override;
};
