#pragma once

#include <saas/library/daemon_base/metrics/metrics.h>

struct TMergerMetrics: public TCompositeMetric {
    TPart<TOrangeMetric> MergeCompleted;
    TPart<TOrangeMetric> MergeFailed;
    TPart<TOrangeMetric> LastMergeTime;
    TPart<TOrangeMetric> MergeStartTime;

    TMergerMetrics()
        : MergeCompleted(this, GetMetricsPrefix() + "IndexMerge_Success")
        , MergeFailed(this, GetMetricsPrefix() + "IndexMerge_Failure")
        , LastMergeTime(this, GetMetricsPrefix() + "IndexMerge_LastTime")
        , MergeStartTime(this, GetMetricsPrefix() + "IndexMerge_MergeStartTime")
    {
    }
};
