#include "policies.h"
#include <saas/rtyserver/common/common_rty.h>
#include <saas/rtyserver/indexer_core/messages.h>

void TMergerPolicyContinuous::OnMergerTaskFinish(ui32 newSegmentsCount, const TString& realmName) const {
    if (newSegmentsCount) {
        INFO_LOG << "Reopen command for continuous merger policy" << Endl;
        TQueuedDocument doc(new TGuardedDocument(Config));
        SendGlobalMessage<TMessageReopenIndexes>(doc, realmName);
    }
}

TMergerPolicyContinuous::TFactory::TRegistrator<TMergerPolicyContinuous> TMergerPolicyContinuous::Registrator(NRTYServer::TMergerConfig::mcpContinuous);
TMergerPolicyNewIndex::TFactory::TRegistrator<TMergerPolicyNewIndex> TMergerPolicyNewIndex::Registrator(NRTYServer::TMergerConfig::mcpNewIndex);
TMergerPolicyNewIndex::TFactory::TRegistrator<TMergerPolicyNewIndexSimple> TMergerPolicyNewIndexSimple::Registrator(NRTYServer::TMergerConfig::mcpNewIndexSimple);
TMergerPolicyNone::TFactory::TRegistrator<TMergerPolicyNone> TMergerPolicyNone::Registrator(NRTYServer::TMergerConfig::mcpNone);
TMergerPolicyTime::TFactory::TRegistrator<TMergerPolicyTime> TMergerPolicyTime::Registrator(NRTYServer::TMergerConfig::mcpTime);
