#include "builder.h"
#include <saas/rtyserver/indexer_core/index_metadata_processor.h>
#include <saas/protos/index_metadata.pb.h>

namespace NRTYServer {

    bool IIndexComponentBuilder::Close(const TBuilderCloseContext& context) {
        RTY_MEM_LOG("Builder " + ComponentName + " close start");
        try {
            TIndexMetadataProcessor indexMetaData(context.DstDir.PathName());
            CHECK_WITH_LOG(DoWriteMeta(*indexMetaData));
        } catch (...) {
            FAIL_LOG("builder %s failed on meta writing: %s", ComponentName.data(), CurrentExceptionMessage().data());
        }
        try {
            return DoClose(context);
        } catch (...) {
            FAIL_LOG("builder %s failed on closing: %s", ComponentName.data(), CurrentExceptionMessage().data());
        }
        RTY_MEM_LOG("Builder " + ComponentName + " close finish");

    }

    void IIndexComponentBuilder::Discard() {
        RTY_MEM_LOG("Builder " + ComponentName + " discard start");
        try {
            return DoDiscard();
        }
        catch (...) {
            FAIL_LOG("builder %s failed on closing: %s", ComponentName.data(), CurrentExceptionMessage().data());
        }
        RTY_MEM_LOG("Builder " + ComponentName + " discard finish");
    }

    void IIndexComponentBuilder::DoDiscard() {
    }

}
