#pragma once

#include "manager.h"
#include <saas/rtyserver/common/path_name.h>
#include <util/generic/vector.h>

struct IYndexStorage;

namespace NIndexerCore {
    class IDirectTextCallback4;
    class IDirectTextCallback2;
}

class TParsedDocument;

namespace NRTYServer {

    class IIndexBuildersStorage;
    class TIndexMetadata;

    struct TBuilderCloseContext {
        const TPathName& SrcDir;
        const TPathName& DstDir;
        const TVector<ui32>* RemapTable;
        const std::atomic<bool> *RigidStopSignal;

        TBuilderCloseContext(const TPathName& srcDir, const TPathName& dstDir, const TVector<ui32>* remapTable, const std::atomic<bool> *rigidStopSignal)
            : SrcDir(srcDir)
            , DstDir(dstDir)
            , RemapTable(remapTable)
            , RigidStopSignal(rigidStopSignal)
        {}
    };

    class IIndexComponentBuilder: public TNonCopyable {
    protected:
        const TString ComponentName;
        virtual bool DoClose(const TBuilderCloseContext& context) = 0;
        virtual bool DoWriteMeta(NRTYServer::TIndexMetadata& /*metaData*/) const { return true; }
        virtual void DoDiscard();

    public:

        IIndexComponentBuilder(const TString& componentName)
            : ComponentName(componentName)
        {

        }

        virtual ~IIndexComponentBuilder() {}
        virtual IIndexComponentManager* GetManager() = 0;
        virtual void Index(int threadID, const TParsedDocument& document, const ui32 docId) = 0;

        virtual bool Close(const TBuilderCloseContext& context) final;
        virtual void Discard() final;
        virtual bool Start() = 0;
        virtual bool Stop() = 0;
        virtual void InitInteractions(const IIndexBuildersStorage& /*storage*/) = 0;
    };

    class IDTIndexBuilder: public IIndexComponentBuilder {
    public:

        IDTIndexBuilder(const TString& componentName)
            : IIndexComponentBuilder(componentName)
        {

        }

        virtual ~IDTIndexBuilder() {}
        virtual void RegisterStoragesAttr(TVector<IYndexStorage*> /*storages*/) {
            FAIL_LOG("NOT APPLICABLE");
        }
        virtual void RegisterStoragesLemm(TVector<IYndexStorage*> /*storages*/) {
            FAIL_LOG("NOT APPLICABLE");
        }
        virtual void RegisterInvCreator(TVector<NIndexerCore::IDirectTextCallback4*> /*callbacks*/) {
            FAIL_LOG("NOT APPLICABLE");
        }
        virtual void RegisterDTCallback(TVector<NIndexerCore::IDirectTextCallback2*> /*callbacks*/) {
            FAIL_LOG("NOT APPLICABLE");
        }
    };

}
