#include "component.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/digest/fnv.h>

namespace NRTYServer {

    IIndexComponent::IIndexComponent(bool isUsed) {
        if (!isUsed) {
            throw TComponentIsUnusedException();
        }
    }

    ui32 IParsedEntity::GetHash() const {
        NRTYServer::TParsedDoc pd;
        MergeToProto(pd, NRTYServer::TDocSerializeContext());
        pd.MutableDocument()->SetUrl("");
        pd.MutableDocument()->SetModificationTimestamp(0);
        pd.MutableDocument()->SetVersionTimestamp(0);
        TBuffer buf(pd.ByteSize());
        TBufferOutput out(buf);
        VERIFY_WITH_LOG(pd.SerializeToArcadiaStream(&out), "Can't serialize document proto");
        return FnvHash<ui32>(buf.Data(), buf.Size());
    }

    void IIndexComponent::SearchCustom(const TVector<IIndexController::TPtr>& controllers, ICustomReportBuilder& builder, const TRTYSearchRequestContext& context) const {
        for (const auto& searcher : controllers) {
            searcher->SearchCustom(builder, context);
        }
    }

    bool IIndexComponent::Merge(const TMergeContext& context) const {
        AssertCorrectConfig(DoMergeMeta(context), "%s", "Metadata are incompatibles each other");
        return DoMerge(context);
    }

    bool IIndexComponent::AllRight(const TNormalizerContext& context) const {
        TIndexMetadataProcessor indexMetaData(context.Dir.PathName());
        AssertCorrectConfig(DoCheckMeta(*indexMetaData), "Config is incompatible with index segment: %s", context.Dir.PathName().data());
        return DoAllRight(context);
    }
}
