#pragma once

#include <util/datetime/base.h>
#include <util/generic/ptr.h>

namespace NRtDoc {
    class TBuilderTask;
    class TBuilderTaskResult;
}

namespace NRTYServer {
    //
    // Interface for calling an ExtBuilder component implementation
    //
    class IExtBuilderClient : public TThrRefBase {
    public:
        using TPtr = TIntrusivePtr<IExtBuilderClient>;
    public:
        virtual void Run(NRtDoc::TBuilderTaskResult& result, NRtDoc::TBuilderTask& task) = 0;
    };

    //
    // Factory class
    //
    class IExtBuilderConnection : public TThrRefBase {
    public:
        using TPtr = TIntrusivePtr<IExtBuilderConnection>;
    protected:
        ~IExtBuilderConnection();
    public:
        virtual IExtBuilderClient::TPtr CreateClient() = 0;
    };

    //
    // Binding point (like TMergerEngine)
    //
    class TExtBuilderEngine final {
    private:
        class TImpl;

    public:
        static void Enable() noexcept; // allows waiting for connection
        static void Disable() noexcept; // drops connection, disallows waiting

        static void RegisterConnection(const IExtBuilderConnection::TPtr& conn);
        static IExtBuilderConnection::TPtr GetConnection();
        static IExtBuilderConnection::TPtr WaitConnection(TInstant deadline = TInstant::Max());
    };
}


