#include "manager.h"

#include <util/system/guard.h>

bool NRTYServer::IIndexComponentManager::Open() {
    NOTICE_LOG << "Manager for " << ComponentName << " component opening..." << Endl;
    TGuard<TMutex> g(MutexOpened_);
    bool result = DoOpen();
    if (result) {
        Opened_ = true;
    }
    NOTICE_LOG << "Manager for " << ComponentName << " component opened " << (result ? "OK" : "FAILED") << Endl;
    return result;
}

bool NRTYServer::IIndexComponentManager::Close() {
    NOTICE_LOG << "Manager for " << ComponentName << " component closing..." << Endl;
    TGuard<TMutex> g(MutexOpened_);
    bool result = DoClose();
    if (result) {
        Opened_ = false;
    }
    NOTICE_LOG << "Manager for " << ComponentName << " component closed " << (result ? "OK" : "FAILED") << Endl;
    return result;
}

std::pair<NSaas::TDocHash, ui32> NRTYServer::IDocSearchInfoIterator::GetHashWithId() const {
    auto info = Get();
    return std::make_pair(info.GetHash(), info.GetDocId());
}
