#include "external_pruning.h"

TExternalPruning::TExternalPruning(const TString& subtype)
    : SubType(subtype)
{}

TPruningConfig::TType TExternalPruning::GetType() const {
    return TPruningConfig::EXTERNAL;
}

const TString& TExternalPruning::GetSubType() const {
    return SubType;
}

TString TExternalPruning::ToString() const {
    return NRTYServer::ExternalPruningPrefix + SubType + ":" + GetData();
}

bool TExternalPruning::PruningOn() const {
    return true;
}

bool TExternalPruning::NeedSort() const {
    return true;
}
