#include "group_attr_pruning.h"

TString TGrAttrPruning::ToString() const {
    return GrAttrName;
}

bool TGrAttrPruning::NeedSort() const {
    return true;
}

bool TGrAttrPruning::PruningOn() const {
    return true;
}

TGrAttrPruning::TGrAttrPruning(const TString& attrName)
    : GrAttrName(attrName)
{}

TGrAttrPruning::TType TGrAttrPruning::GetType() const {
    return GROUP_ATTR;
}

TOXYPruning::TType TOXYPruning::GetType() const {
    return OXY;
}

bool TOXYPruning::PruningOn() const {
    return true;
}

bool TOXYPruning::NeedSort() const {
    return true;
}

TString TOXYPruning::ToString() const {
    return "oxy";
}
