#include "pruning_config.h"
#include "docid_pruning.h"
#include "formula_pruning.h"
#include "group_attr_pruning.h"
#include "tm_pruning.h"
#include <util/generic/singleton.h>
#include <util/string/split.h>

double TPruningConfig::ICalcer::PruningRank(ui32 /*docid*/) const {
    return 0;
}

double TPruningConfig::ICalcer::PruningRankByDoc(const IDocument* /*document*/) const {
    return 0;
}

TString TPruningConfig::ToString() const {
    return TString();
}

bool TPruningConfig::NeedSort() const {
    return false;
}

bool TPruningConfig::PruningOn() const {
    return false;
}

TPruningConfig* TPruningConfig::Create(const TString& data) {
    if (!data)
        return new TPruningConfig();
    if (data == "oxy")
        return new TOXYPruning();
    if (data == "docid")
        return new TDocIdPruning();
    if (data == "tm")
        return new TTmPruning();
    if (data.StartsWith(NRTYServer::FormulaPruningPrefix))
        return new TFormulaPruning(data.substr(NRTYServer::FormulaPruningPrefix.size()));
    if (data.StartsWith(NRTYServer::ExternalPruningPrefix)) {
        TString type, initdata;
        TString typeAndData = data.substr(NRTYServer::ExternalPruningPrefix.size());
        if (typeAndData.find(':') == TString::npos) {
            type = typeAndData;
        } else {
            Split(typeAndData,':', type, initdata);
        }
        if (auto* res = TFactory::Construct(type, type, initdata)) {
            return res;
        }
    }
    return new TGrAttrPruning(data);
}

TPruningConfig::TType TPruningConfig::GetType() const {
    return NO;
}

const TString& TPruningConfig::GetSubType() const {
    return Default<TString>();
}
