#pragma once

#include <kernel/factor_storage/factor_storage.h>
#include <library/cpp/object_factory/object_factory.h>
#include <util/generic/string.h>

namespace NRTYServer {
    const TString FormulaPruningPrefix = "formula:";
    const TString ExternalPruningPrefix = "external-";
}

class TPruningConfig {
public:
    class IDocument {
    public:
        virtual ~IDocument() {}
        virtual bool GetGroupAttrValue(const TString& name, i64& result) const = 0;
        virtual void FillFactorStorage(TFactorView& factorStorage) const = 0;
        virtual ui64 GetTimestamp() const = 0;
        virtual const TString& GetUrl() const = 0;
        virtual ui64 GetKeyPrefix() const = 0;
    };

    class ICalcer {
    public:
        virtual ~ICalcer() {}
        virtual double PruningRank(ui32 docid) const;
        virtual double PruningRankByDoc(const IDocument* document) const;
    };

    using TFactory = NObjectFactory::TParametrizedObjectFactory<TPruningConfig, TString, TString, TString>;

public:
    enum TType {NO, DOCID, GROUP_ATTR, FORMULA, OXY, TM, EXTERNAL};
    static TPruningConfig* Create(const TString& data);
    virtual TString ToString() const;
    virtual bool NeedSort() const;
    virtual bool PruningOn() const;
    virtual TType GetType() const;
    virtual const TString& GetSubType() const;

    virtual ~TPruningConfig() {}

protected:
    TPruningConfig() {}
};
