#include "dead_docs_clear.h"

#include <saas/rtyserver/common/common_messages.h>
#include <library/cpp/mediator/messenger.h>
#include <library/cpp/logger/global/global.h>

void TDeadDocsCleanerWatchDogHandle::DoCheck(TInstant /*timeNow*/) {
    try {
        TMessageRemoveDeadDocuments messageRemoveOld(Now().Minutes());
        SendGlobalMessage(messageRemoveOld);
    } catch (const yexception& e) {
        Cerr << "Exception during DeadDocs cleaner: " << e.what() << Endl;
        ERROR_LOG << "Exception during DeadDocs cleaner: " << e.what() << Endl;
    } catch (...) {
        // Do nothing
    }
}
