#pragma once

#include "repair.h"
#include <saas/rtyserver/components/fullarchive/disk_manager.h>
#include <saas/util/queue.h>
#include <saas/rtyserver/modifier/document_modifier.h>
#include <util/system/event.h>

#include <atomic>

class TFileIndexer {
public:
    TFileIndexer(const TString& directory, TIndexRepair& owner, TDocumentModifier& modifier);
    bool Run();

private:
    class TLockCallback : public INamedLockManager::ICallback {
    public:
        TLockCallback(TFileIndexer& owner, const TQueuedDocument& qDoc);
        virtual void OnLock(INamedLockManager::TNamedLockPtr lock);
    private:
        TFileIndexer& Owner;
        TQueuedDocument QDoc;
    };

    class TIndexerTask : public IObjectInQueue {
    public:
        TIndexerTask(TFileIndexer& owner, const TQueuedDocument& qDoc);
        ~TIndexerTask();
        virtual void Process(void* /*ThreadSpecificResource*/);
    private:
        TFileIndexer& Owner;
        TQueuedDocument QDoc;
    };

    void IndexDocument(const TQueuedDocument& qDoc);
    TString Directory;
    TDiskFAManager FullArchive;
    TIndexRepair& Owner;
    ui64 CountPushedDocuments;
    ui64 CountRepairedDocuments;
    TSystemEvent DocProcessed;
    TRTYMtpQueue IndexQueue;
    TString TempDirName;
    typedef TAutoPtr<IIndexer> TIndexerPtr;
    typedef TList<TIndexerPtr> TFullIndexers;
    TIndexerPtr Indexer;
    TFullIndexers FullIndexers;
    std::atomic<bool> Result;
    TDocumentModifier& Modifier;
};
