#include "web_adapter.h"
#include "ann_features.h"

#include <saas/rtyserver/search/cgi/rty_ranking_opts.h>
#include <ysite/yandex/relevance/common/ya_tr_params.h>
#include <search/relevance/dynamic_web_features.h>
#include <search/reqparam/reqparam.h>
#include <search/reqparam/search_specific_lazy_fillers/factor_mask.h>

namespace NRTYServer {
    //
    // TCreatorOfDynamicFeatures
    //
    TCreatorOfDynamicFeatures::TCreatorOfDynamicFeatures(const TRTYRankingOpts* rankingOpts)
        : WebCalcer(new TCreatorOfWebBasesearchDynamicFeaturesCalcer)
        , RankingOpts(*rankingOpts)
    {
        Y_ASSERT(rankingOpts != nullptr);
    }

    ICustomDynamicFeaturesCalcer* TCreatorOfDynamicFeatures::Create(TParamsToCustomDynamicFeaturesCalcer& params) {
        if (!RankingOpts.ReplaceAnnCalcer) {
            return WebCalcer->Create(params);
        } else {
            const TAnnFeaturesParams* annFeaturesParams = nullptr;
            std::swap(annFeaturesParams, params.AnnFeaturesParams); // disables the standard gator from Web
            THolder<ICustomDynamicFeaturesCalcer> result = THolder(WebCalcer->Create(params));
            std::swap(annFeaturesParams, params.AnnFeaturesParams);
            if (Y_LIKELY(DefaultFactorMask(params.RP.FactorMask).Group.Annotation() && params.AnnFeaturesParams != nullptr)) {
                const TVector<TCateg> allRegions = !RankingOpts.UseRegionChain ? TVector<TCateg>() : params.RP.AllRegions;
                params.GatorRegister->RegisterGator(TRelevanceTypeMask::Annotation,
                                                    new (params.Pool) TRTYQuorumAnnFeaturesCalcer(params.AnnFeaturesParams,
                                                                                                  params.YaTRParams.WordWeight,
                                                                                                  allRegions,
                                                                                                  RankingOpts));
            }
            return result.Release();
        }
    }
}
