#include "info.h"

#include <saas/library/histogram/histogram.h>

#include <library/cpp/json/json_value.h>

void NRTYServer::TInfoContextEx::DoCalcInfo() {
    const TString& type = RP_->InfoParams.Type;

    if (type == "docinfo") {
        TString p;
        if (!RP_->InfoParams.Params.TryGet("docid", p)) {
            Stream << "cannot find DocId";
            return;
        }

        const ui32 docId = Owner_.GetDocIdStats().ResolveDocIdFromMeta(TDocHandle(p));
        NJson::TJsonValue info;
        if (IndexController->GetDocInfo(docId, info)) {
            NJson::TJsonValue result(NJson::JSON_ARRAY);
            result.AppendValue(info);
            Stream << result.GetStringRobust();
        } else {
            Stream << "cannot get DocInfo";
        }
        return;
    }
    if (type == "histogram") {
        const auto& serialized = IndexController->GetHistograms().Serialize<NJson::TJsonValue>();
        Stream << serialized.GetStringRobust();
        return;
    }
    if (type == "doccount") {
        Stream << IndexController->GetSearchableDocumentsCount();
        return;
    } else {
        ::TInfoContext::DoCalcInfo();
    }
}
