#pragma once

#include <search/memory/search.h>
#include <search/base/infocontext.h>
#include <saas/rtyserver/model/index.h>

namespace NRTYServer {

    class TInfoContextEx : public ::TInfoContext {
    public:
        TInfoContextEx(
            IIndexController::TPtr controller,
            const TBaseIndexData& bid,
            const TBaseCommonSearch& owner,
            const TSearchRequestData& rd
        )
            : ::TInfoContext(bid, bid.GetArchiveManager(), owner, rd)
            , IndexController(controller)
        {
        }

    protected:
        virtual void DoCalcInfo() override;

    private:
        IIndexController::TPtr IndexController;
    };

    class TMemoryInfoContextEx
        : public IInfoContext
        , public NMemorySearch::TMemoryContextBase
    {
    public:
        TMemoryInfoContextEx(IIndexController::TPtr controller, const NMemorySearch::TMemorySearch& owner, const TSearchRequestData& rd)
            : TMemoryContextBase(owner)
            , InfoContext(controller, *BaseIndexData, owner, rd)
        {}
        virtual int CalcInfo() {
            return InfoContext.CalcInfo();
        }
        virtual TBufferStream& GetInfoDataStream() {
            return InfoContext.GetInfoDataStream();
        }
    private:
        TInfoContextEx InfoContext;
    };
}
