#include "search.h"
#include "info.h"

#include <search/base/fetch_doc_data_context.h>
#include <search/base/yx_search.h>
#include <search/memory/search.h>

namespace NRTYServer {
    class TBaseSearchEx: public ::TBaseSearch {
    public:
        TBaseSearchEx(IIndexController::TPtr controller)
            : IndexController(controller)
        {
        }

        IFetchDocDataContext* CreateFetchDocDataContext() const override {
            return new TWebFetchDocDataContext(BaseIndexData);
        }

        IInfoContext* CreateInfoContext(const TSearchRequestData& rd) const override {
            Y_ASSERT(BaseIndexData);
            return new NRTYServer::TInfoContextEx(IndexController, *BaseIndexData, *this, rd);
        }
    private:
        const IIndexController::TPtr IndexController;
    };

    class TMemorySearchEx: public NMemorySearch::TMemorySearch {
    public:
        TMemorySearchEx(IIndexController::TPtr controller, const NMemorySearch::TMemorySearchOptions& options)
                : TMemorySearch(options)
                , IndexController(controller)
        {
        }

        IInfoContext* CreateInfoContext(const TSearchRequestData& rd) const override {
            return new NRTYServer::TMemoryInfoContextEx(IndexController, *this, rd);
        }
    private:
        const IIndexController::TPtr IndexController;
    };
}

THolder<TBaseSearch> NRTYServer::CreateBaseSearch(IIndexController::TPtr contoller) {
    return MakeHolder<NRTYServer::TBaseSearchEx>(contoller);
}

THolder<NMemorySearch::TMemorySearch> NRTYServer::CreateMemorySearch(IIndexController::TPtr contoller, const NMemorySearch::TMemorySearchOptions& options) {
    return MakeHolder<NRTYServer::TMemorySearchEx>(contoller, options);
}
