#include "rty_search_statistics.h"

#include <saas/rtyserver/unistat_signals/signals.h>

TRTYSearchStatistics::~TRTYSearchStatistics() {
    if (IsAnyDssmMismatched) {
        TSaasRTYServerSignals::DoUnistatRecordDocDssm(IsAnyDssmMismatched.GetRef());
    }

    if (IsUserFactorDefaulted) {
        TSaasRTYServerSignals::DoUnistatUserFactorCalcDefault();
    }

    if (IsUserFactorFailed) {
        TSaasRTYServerSignals::DoUnistatUserFactorCalcError();
    }
}

void TRTYSearchStatistics::ReportDocumentDssmRequested() {
    if (!IsAnyDssmMismatched.Defined()) {
        IsAnyDssmMismatched = false;
    }
}

void TRTYSearchStatistics::ReportDocumentDssmNotFound() {
    IsAnyDssmMismatched = true;
}

void TRTYSearchStatistics::ReportMultipleDocumentDssmFound() {
    IsAnyDssmMismatched = true;
}

void TRTYSearchStatistics::ReportUserFactorDefaulted() {
    IsUserFactorDefaulted = true;
}

void TRTYSearchStatistics::ReportUserFactorCalcFailed() {
    IsUserFactorFailed = true;
}
