#pragma once

#include <util/generic/maybe.h>

// Provides functionality for reporting events on per-request basis
class TRTYSearchStatistics {
public:
    void ReportDocumentDssmRequested();
    void ReportDocumentDssmNotFound();
    void ReportMultipleDocumentDssmFound();
    void ReportUserFactorDefaulted();
    void ReportUserFactorCalcFailed();

    ~TRTYSearchStatistics();

private:
    TMaybe<bool> IsAnyDssmMismatched;
    bool IsUserFactorDefaulted {false};
    bool IsUserFactorFailed {false};
};
