#include "replier.h"

#include <saas/rtyserver/unistat_signals/signals.h>
#include <saas/rtyserver/logging/rty_access.h>
#include <saas/rtyserver/search/metrics.h>

void NRTYServer::TCommonReplierFeatures::OnRequestExpired(IReplyContext::TPtr context, TSearchServerMetrics* metrics) {
    if (metrics) {
        metrics->DroppedRequests.Inc();
    }

    TSaasRTYServerSignals::DoUnistatTimeouted();

    if (context) {
        TRTYAccessLog::LogError(context->GetRequestId(), Now() - context->GetRequestStartTime(), ErrorTimeout);
    } else {
        TRTYAccessLog::LogError(ErrorTimeout);
    }
}

void NRTYServer::TCommonReplierFeatures::OnQueueFailure(IReplyContext::TPtr context, TSearchServerMetrics* metrics) {
    if (metrics) {
        metrics->TimeoutDrops.Inc();
    }

    TSaasRTYServerSignals::DoUnistatUnavailable();

    if (context) {
        TRTYAccessLog::LogError(context->GetRequestId(), Now() - context->GetRequestStartTime(), ErrorQueueFailure);
    } else {
        TRTYAccessLog::LogError(ErrorQueueFailure);
    }
}
