#include "request.h"
#include "server.h"

#include <saas/library/searchserver/delay.h>
#include <saas/rtyserver/unistat_signals/signals.h>
#include <search/config/default_config.h>
#include <search/config/virthost.h>
#include <search/request/data/reqdata.h>
#include <search/session/comsearch.h>
#include <kernel/groupattrs/docsattrs.h>

bool TMetaRequestFeatures::BuildCommonSearch(TSearchRequestData& rd) {
    TSearchRequestDelay::Process(rd, "rty_meta");
    TSaasRTYServerSignals::DoUnistatRequestData(rd.CgiParam);
    const TSearchEnginesManager& sem = GetFeatures().GetSearchEnginesManager();
    CommonSearch = sem.GetAppropriateSearcher(rd);
    if (!CommonSearch) {
        return false;
    }
    if (!CommonSearch->GetIsMetaSearch()) {
        CHECK_WITH_LOG(!!CommonSearch->GetIndexController());
        CHECK_WITH_LOG(CommonSearch->GetIndexController()->IsSearching());
        rd.SetPath("/" + ToString(CommonSearch->GetPathIndex()));

        // realCommonSearch is an instance of TCommonSearch class defined here:
        // https://a.yandex-team.ru/arc/trunk/arcadia/search/session/comsearch.h?rev=5176674#L112
        auto realCommonSearch = CommonSearch->GetIndexController()->GetCommonSearch();
        if (realCommonSearch) {
            ConfigureRequestParams(realCommonSearch->Config->ProtoCollection_.GetSearchType(), *rd.RP);
        }
    }
    return true;
}
