#pragma once

#include <saas/rtyserver/search/search_engines_manager.h>

class TMetaSearchServerFeatures;
class TSearchRequestData;

class TMetaRequestFeatures {
private:
    TAtomic GlobalObjectsCount = 0;

protected:
    inline TMetaRequestFeatures() {
        AtomicIncrement(GlobalObjectsCount);
    }
    inline ~TMetaRequestFeatures() {
        AtomicDecrement(GlobalObjectsCount);
    }

    bool BuildCommonSearch(TSearchRequestData& rd);

    virtual TMetaSearchServerFeatures& GetFeatures() = 0;

protected:
    // Hold lock during request processing
    TSearchEnginesManager::TGuardedSearchPtr CommonSearch;
};
