#pragma once

#include <saas/rtyserver/config/fwd.h>
#include <saas/util/events_rate_calcer.h>
#include <saas/util/queue.h>

#include <library/cpp/http/static/static.h>
#include <library/cpp/mediator/messenger.h>

#include <util/system/mutex.h>

class TSearchEnginesManager;

class TDefaultKeyPrefix: public IMessageProcessor {
    const TString FileName;
    ui64 Prefix;
    TMutex Mutex;

public:
    TDefaultKeyPrefix(const NRTYServer::TSearcherConfig& config);
    virtual ~TDefaultKeyPrefix();

    void Set(ui64 prefix);
    ui64 Get() const {
        return Prefix;
    }

    // IMessageProcessor
    virtual TString Name() const;
    virtual bool Process(IMessage* message);
};

class TMetaSearchServerFeatures: public IMessageProcessor {
protected:
    TSearchEnginesManager& SearchEngineManager;
    const NRTYServer::TSearcherConfig& Config;
    const TDefaultKeyPrefix* DefaultKeyPrefix;

public:
    TMetaSearchServerFeatures(TSearchEnginesManager& sem, const NRTYServer::TSearcherConfig& config, const TDefaultKeyPrefix* defaultKeyPrefix = nullptr)
        : SearchEngineManager(sem)
        , Config(config)
        , DefaultKeyPrefix(defaultKeyPrefix)
    {
    }

    inline ui64 GetDefaultKps() const {
        return DefaultKeyPrefix ? DefaultKeyPrefix->Get() : 0;
    }

    const NRTYServer::TSearcherConfig& GetConfig() const {
        return Config;
    }

    TSearchEnginesManager& GetSearchEnginesManager() {
        return SearchEngineManager;
    }
};
