#pragma once

#include <library/cpp/deprecated/atomic/atomic.h>

#include <search/idl/meta.pb.h>

class TCommonSearch;

class TCommonSearchRequest {
private:
    const TCommonSearch* const Search;
    const TString Query;
    const TString SearcherHost;
    const ui16 SearcherPort;
    NMetaProtocol::TReport Report;
    TAtomic RequestId;

private:
    void DoExecute();

public:
    TCommonSearchRequest(const TCommonSearch* search, const TString& query, const TString& searcherHost, const ui16 searcherPort);

    inline const NMetaProtocol::TReport& GetReport() {
        DoExecute();
        return Report;
    }
};

