#pragma once

#include <search/config/virthost.h>
#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/config/searcher_config.h>
#include <saas/rtyserver/common/path_name.h>

namespace NRTYServer {
    class IExternalSearchCreator;
}

class TSearchConfigBuilder {
protected:
    explicit TSearchConfigBuilder(const TRTYServerConfig& config);
    ~TSearchConfigBuilder();

    void ApplyMainConfig(TSearchConfig* searchConfig, const TPathName& dir, NRTYServer::TSearcherConfig::TSearchConfigType searcherType) const;

protected:
    const TRTYServerConfig& Config;
    THolder<NRTYServer::IExternalSearchCreator> ExternalSearchCreator;
};
