#include "search_config_builder_base.h"
#include <saas/rtyserver/indexer_core/index_component_storage.h>
#include <saas/rtyserver/indexer_core/index_dir.h>
#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/config/searcher_config.h>

TSearchConfigBuilderBase::TSearchConfigBuilderBase(const TRTYServerConfig& config)
    : TSearchConfigBuilder(config)
{}

TAutoPtr<TSearchConfig> TSearchConfigBuilderBase::GetSearchConfig(const TPathName& dir, bool hasSearcher) const {
    TAutoPtr<TSearchConfig> searchConfig;
    if (!!Config.GetSearcherConfig().DefaultConfigInstances[NRTYServer::TSearcherConfig::sctBase])
        searchConfig.Reset(new TSearchConfig(*Config.GetSearcherConfig().DefaultConfigInstances[NRTYServer::TSearcherConfig::sctBase].Get()));
    else
        searchConfig.Reset(new TSearchConfig);
    ApplyMainConfig(searchConfig.Get(), dir, NRTYServer::TSearcherConfig::sctBase);
    if (!hasSearcher) {
        // Disable some data loading for non-active basesearch instances.
        searchConfig->UserDirectives.erase("ArchiveOpenMode");
        searchConfig->UserDirectives.erase("InMemoryArchive");
        searchConfig->UserDirectives.erase("MemoryMappedArchive");
        searchConfig->UserDirectives.erase("CacheArchive");
        searchConfig->ProtoCollection_.SetPrefetchSize(0);
        searchConfig->ProtoCollection_.ClearMXNetFile();
    }

    const bool isRamDrive = NRTYServer::IsIndexDirOnTmpfs(searchConfig->IndexDir);
    if (isRamDrive) {
        // disallow directIO for WAD archives
        searchConfig->ProtoCollection_.SetUseArchiveFromMemory(true);
        // try not to load whole files into anonymous memory blobs
        searchConfig->ProtoCollection_.SetAllFilesLockMemory(false);
    }

    TIndexComponentsStorage::Instance().CorrectSearchConfig(*searchConfig.Get(), NRTYServer::TSearcherConfig::sctBase);
    return searchConfig;
}

