#include "search_config_builder_memory.h"
#include <saas/rtyserver/indexer_core/index_component_storage.h>
#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/config/searcher_config.h>

TSearchConfigBuilderMemory::TSearchConfigBuilderMemory(const TRTYServerConfig& config)
    : TSearchConfigBuilder(config)
{}

TAutoPtr<TSearchConfig> TSearchConfigBuilderMemory::GetSearchConfig(const TPathName& dir) const {
    TAutoPtr<TSearchConfig> searchConfig;
    if (!!Config.GetSearcherConfig().DefaultConfigInstances[NRTYServer::TSearcherConfig::sctMemory])
        searchConfig.Reset(new TSearchConfig(*Config.GetSearcherConfig().DefaultConfigInstances[NRTYServer::TSearcherConfig::sctMemory].Get()));
    else if (!!Config.GetSearcherConfig().DefaultConfigInstances[NRTYServer::TSearcherConfig::sctBase])
        searchConfig.Reset(new TSearchConfig(*Config.GetSearcherConfig().DefaultConfigInstances[NRTYServer::TSearcherConfig::sctBase].Get()));
    else
        searchConfig.Reset(new TSearchConfig);
    ApplyMainConfig(searchConfig.Get(), dir, NRTYServer::TSearcherConfig::sctBase);
    ApplyMainConfig(searchConfig.Get(), dir, NRTYServer::TSearcherConfig::sctMemory);

    TIndexComponentsStorage::Instance().CorrectSearchConfig(*searchConfig.Get(), NRTYServer::TSearcherConfig::sctMemory);
    return searchConfig;
}

