#pragma once

#include <util/generic/map.h>
#include <util/generic/string.h>

class TCgiParameters;
class TRequestParams;
struct TRTYServerConfig;

class TRTYSearchRequestContext {
public:
    using TComponentParameters = TMap<TString, TString>;

public:
    TRTYSearchRequestContext(const TCgiParameters& cgi, TRequestParams& rp, const TRTYServerConfig& serverConfig);

    const TCgiParameters& CgiParams() const;
    const TRequestParams& GetRP() const;
    const TString& GetComponentName() const;

    const TComponentParameters* GetParameters(const TString& componentName) const;

    bool UseFilters() const {
        return !ParamsPerComponent.empty();
    }

private:
    bool Parse(const TString& paramsStr, TString& componentName, TComponentParameters& parameters) const;

private:
    const TCgiParameters& Cgi;
    const TRequestParams& RP;
    const TRTYServerConfig& Config;
    TMap<TString, TComponentParameters> ParamsPerComponent;
};
