#pragma once

#include "text_machine.h"

#include <saas/rtyserver/factors/factors_mask.h>
#include <saas/rtyserver/search/ann_features/ann_features.h>

//
// TRTYRankingPassContext: contains all iterator-like entities that are created by RTYRelevance for a ranking pass
//
// @details
//     If you look at TIntervalFilteringResultsCalcer, there are some enitites that have to be created before the first pass,
//     and then to be reset before the second one. This includes keyinv iterators, text machines etc.
//     This structure incapsulates such extensions when they appear in RTYServer.
//
// @note Should someone decide to make TRTYRelevance support multithreaded ranking mode, he must provide a separate RTYRankingPassContext
//       for each one of the threads
//
struct TRTYRankingPassContext {
    bool IsSecond = false;
    const NRTYFactors::TRTYFactorMask* RTYFactorMask = nullptr; // may be null when there is no relevance
    THolder<NLingBoost::TWordConfig> WordConfig;
    TIntrusivePtr<TSaasTextMachineFeaturesCalcer> TmCustomCalcer;
    mutable THolder<TRTYFactorAnnFeaturesCalcer> FactorAnnCalcer;
};
