#pragma once

#include <saas/rtyserver/search/factory/factory.h>

#include "factors_mask.h"
#include "rty_filtration.h"

class TRTYMetaCustomCgi: public ICustomCgi {
public:
    TRTYMetaCustomCgi(const TRTYServerConfig& globalConfig)
        : GlobalConfig(globalConfig)
    {
    }

    virtual void TreatCgiParams(TRequestParams& rp, const TCgiParameters& cgiParams) override;

private:
    const TRTYServerConfig& GlobalConfig;
};

class TRTYExternalSearch: public IExternalSearch {
private:
    const TBaseCommonSearch& Owner;
    TFactorsMaskCache FactorsMaskCache;
    IRemapperUrlDocId& Remapper;
    TRTYIndexData* IndexData;
    TRTYFiltrationModelFactory FiltrationModelFactory;

public:
    TRTYExternalSearch(const NRTYServer::IExternalSearchCreator::TParams& params);

    virtual void SerializeFirstStageAttributes(ui32 docId, TArrayRef<const char * const> attrName, IAttributeWriter& write) const override;

    virtual void TuneIndexDocIdsFraction(double* fraction) const override {
        *fraction = 0.;
    }

    const IFactorsInfo* GetFactorsInfo() const override;
    virtual IIndexData* GetIndexData() override;
    virtual void Init(const TSearchConfig*) override;
    virtual void FillCustomProperties(TSearcherProps* props, const TRequestParams* rp) const override;
    virtual IRelevance* CreateRelevance(const TBaseIndexData& baseIndexData, TIndexAccessors& /*accessors*/, const TRequestParams* rp) const override;
    virtual void PrepareRequestParams(TRequestParams* rp) const override;
    virtual void TuneRequestParams(TRequestParams* rp) const override;
    virtual bool ProcessInfoRequest(const TRequestParams& rp, TBufferStream& outputStream) const override;
    virtual bool UseMemoryPool() const override;
    virtual const IUrlIdInfo* GetUrlIdInfo() const override;
};

