#pragma once

#include <kernel/externalrelev/sent_zones.h>
#include <util/generic/ylimits.h>
#include <util/generic/set.h>

class IMakeupStorage;

///
/// TRTYIndexTextData: конфиг и локатор моделей для новых текстовых фичей (LB, DSSM и т.д.), которые не хотим настраивать в relev.conf
///
/// @seealso NRTYFactors::TConfig
///

class TRTYIndexTextData {
public:
    struct TData {
        ui32 AutoTitleSentNum = Max<ui32>();
        const IMakeupStorage* Makeup = nullptr;
    };

private:
    const TData Data;

public:
    ui32 GetAutoTitleSentNum() const {
        return Data.AutoTitleSentNum;
    }

    TSentenceZones GetTitleZonesMask() const;

public:
    TRTYIndexTextData(TData&& data)
        : Data(data)
    {
    }

    TRTYIndexTextData(const TData& data)
        : Data(data)
    {
    }
};

namespace NRTYServer {
    TString GetArcTitle(const ui8* blob, ui32 docId, const ISentenceZonesReader* sentReader, TSentenceZones zonesMask, const ui32 autoTitleSentNum);
}
