#include "text_machine_plugin.h"

#include <extsearch/kinopoisk/base/calc_factors/text_machine/production_features_calcer.h>

#include <extsearch/ymusic/base/calc_factors/text_machine/production_features_calcer.h>
#include <extsearch/ymusic/base/search/streamizer.h>

#include <search/lingboost/production/web_production_features_calcer.h>

#include <kernel/factor_slices/factor_slices_gen.h>
#include <kernel/factor_storage/factor_storage.h>

//
// ISaasTextMachinePlugin
//
const NLingBoost::TWordConfig* ISaasTextMachinePlugin::GetWordConfig() const {
    return &NLingBoost::GetRelaxedWordConfig();
}

const NLingBoost::TRawConfig* ISaasTextMachinePlugin::GetRawConfig() const {
    return &NLingBoost::GetRelaxedRawConfig();
}

namespace NRTYServer {
    //
    // TSaasTextMachine
    //
    NFactorSlices::EFactorSlice TSaasTextMachine::GetTargetSlice() const {
        return NFactorSlices::EFactorSlice::WEB_PRODUCTION;
    }

    THolder<NLingBoost::IProductionFeaturesCalcer> TSaasTextMachine::CreateProductionCalcer(const NTextMachine::TExpansionOptions& options) const {
        return THolder(new NLingBoost::TWebProductionFeaturesCalcer(options));
    }

    ISaasTextMachinePlugin::TFactory::TRegistrator<TSaasTextMachine> TSaasTextMachine::Registrator("");

    //
    // TSaasTextMachine2
    //
    ISaasTextMachinePlugin::TFactory::TRegistrator<TSaasTextMachine2> TSaasTextMachine2::Registrator("web");

    //
    // TMusicTextMachine
    //
    NFactorSlices::EFactorSlice TMusicTextMachine::GetTargetSlice() const {
        return NFactorSlices::EFactorSlice::YMUSIC_TEXT_MACHINE;
    }

    THolder<NLingBoost::IProductionFeaturesCalcer> TMusicTextMachine::CreateProductionCalcer(const NTextMachine::TExpansionOptions& options) const {
        return THolder(new NYmusic::NLingBoost::TProductionFeaturesCalcer(options));
    }

    THolder<NLingBoost::IHitsStreamizer> TMusicTextMachine::CreateAnnHitsStreamizer(
        TCateg relevCountry,
        const NIndexAnn::IDocDataIndex* annIndex,
        const TSentenceLengthsReader* annSentReader) const {
        return NYmusic::NLingBoost::CreateAnnHitsStreamizer(relevCountry, annIndex, annSentReader);
    }

    THolder<NLingBoost::IHitsStreamizer> TMusicTextMachine::CreateFactorAnnHitsStreamizer(
        TCateg relevCountry,
        const NIndexAnn::IDocDataIndex* factorAnnIndex,
        const TSentenceLengthsReader* factorAnnSentLenReader) const {
        return NYmusic::NLingBoost::CreateFactorAnnHitsStreamizer(relevCountry, factorAnnSentLenReader, factorAnnIndex);
    }

    ISaasTextMachinePlugin::TFactory::TRegistrator<TMusicTextMachine> TMusicTextMachine::Registrator("music");

    // 
    // TKinopoiskTextMachine
    //
    NFactorSlices::EFactorSlice TKinopoiskTextMachine::GetTargetSlice() const {
        return NFactorSlices::EFactorSlice::KP_TEXT_MACHINE;
    }

    THolder<NLingBoost::IProductionFeaturesCalcer> TKinopoiskTextMachine::CreateProductionCalcer(const NTextMachine::TExpansionOptions& options) const {
        return THolder(new NKinopoisk::NLingBoost::TProductionFeaturesCalcer(options));
    }

    ISaasTextMachinePlugin::TFactory::TRegistrator<TKinopoiskTextMachine> TKinopoiskTextMachine::Registrator("kinopoisk");
}
